<?php
	include_once dirname(__FILE__).'/ask.class.php';

	$askobj=new ask();

	function question_typename($typeid=0)
	{
		global $askobj;
		return $askobj->typename(intval($typeid));
	}

	function question_typeurl($id,$is_rewrite=1,$preview=0)
	{
		global $askobj;
		return $askobj->formatqtypeurl($id,$is_rewrite,$preview);
	}

	function formatquestionurl($id,$is_rewrite=1,$preview=0)
	{
		global $askobj;
		return $askobj->formatquestionurl($id,$is_rewrite,$preview);
	}

	function askcount($askid)
	{
		return get_cache_counts("SELECT COUNT(*) AS count FROM `".LA_PRE."ask_answer` WHERE `".LA_PRE."ask_answer`.`qid`=".intval($askid));
	}

	function parse_ask_template($str)
	{
		$str=preg_replace('/\{niubi:question\s+([^\}]+)\}/ie',"la_call_user_func('get_question_tag','\\1')",$str);
		$str=preg_replace('/\{\/niubi:question\}/i',"<?php }unset(\$_DATA); ?>",$str); 

		$str=preg_replace('/\{niubi:answer\s+([^\}]+)\}/ie',"la_call_user_func('get_answer_tag','\\1')",$str);
		$str=preg_replace('/\{\/niubi:answer\}/i',"<?php }unset(\$_DATA); ?>",$str); 

		$str=preg_replace('/\{niubi:asktype\s+([^\}]+)\}/ie',"la_call_user_func('get_asktype_tag','\\1')",$str);
		$str=preg_replace('/\{\/niubi:asktype\}/i',"<?php }unset(\$_DATA); ?>",$str); 

		return $str;
	}

	function get_asktype_tag($para)
	{
		/*
			Ĭϲ
		*/
		$args=array('limit'=>'0',
					'row'=>'16');
		foreach($para as $key => $arg)
		{
			if(isset($args[$key]))
			{
				$args[$key]=$arg;
			}
		}
		
		extract($args);
		
		$mod=!$mod?0:array_map('intval',explode(',',$mod));
		$row=intval($row)>0?intval($row):10;
		return '<?php $_DATA=get_asktype_data('.$limit.','.$row.');foreach($_DATA as $no => $r)if(is_array($r)){?>';
	}

	function get_asktype_data($limit,$row)
	{
		global $cacheobj,$db,$siteidobj,$bbsobj;
		$limit=intval($limit)?intval($limit):0;
		$row=intval($row)?intval($row):16;

		if(SITETYPE && $_SESSION['siteid'])
		{
			$where='siteid IN('.implode(',',$siteidobj->getchildid($_SESSION['siteid'])).')';
		}
		else
		{
			$where='1';
		}
		
		$sql="SELECT * FROM `".LA_PRE."ask_type` WHERE $where ORDER BY `".LA_PRE."ask_type`.`id` ASC LIMIT $limit,$row";

		$data=$cacheobj->get($sql);
		if(!$data)
		{
			$data=$db->fetch_all($sql);
			if($data)
			{
				$cacheobj->set($sql,$data);
			}
		}
		return $data;
	}

	function get_question_tag($para)
	{
		/*
			Ĭϲ
		*/
		$args=array('typeid'=>'0',
					'limit'=>'0',
					'row'=>'16',
					'isend'=>'-1',
					'istop'=>'-1',
					'withthumb'=>'0');
		foreach($para as $key => $arg)
		{
			if(isset($args[$key]))
			{
				$args[$key]=$arg;
			}
		}
		
		extract($args);
		
		$mod=!$mod?0:array_map('intval',explode(',',$mod));
		$row=intval($row)>0?intval($row):10;
		return '<?php $_DATA=get_question_data('.$typeid.','.$limit.','.$row.','.$isend.','.$istop.','.$withthumb.');foreach($_DATA as $no => $r)if(is_array($r)){?>';
	}

	function get_question_data($typeid,$limit,$row,$isend,$istop,$withthumb)
	{
		global $cacheobj,$db,$siteidobj,$bbsobj;
	
		$result=$_DATA=array();
		$typeid=intval($typeid)?intval($typeid):0;
		$limit=intval($limit)?intval($limit):0;
		$row=intval($row)?intval($row):16;
		$istop=intval($istop)>-1?intval($istop):-1;
		$isend=intval($isend)>-1?intval($isend):-1;

		if(SITETYPE && $_SESSION['siteid'])
		{
			$where='siteid IN('.implode(',',$siteidobj->getchildid($_SESSION['siteid'])).') AND status!=0';
		}
		else
		{
			$where='status!=0';
		}
		
		$where.=$typeid?' AND typeid='.$typeid:'';

		if($istop==-1)
		{
			$where.='';
		}
		else if($istop==0)
		{
			$where.=' AND (istop='.intval($istop).' OR istop<'.TIME.')';
		}
		else
		{
			$where.=' AND istop>='.TIME;
		}

		if($isend==-1)
		{
			$where.='';
		}
		else if($isend==0)
		{
			$where.=' AND aid=0';
		}
		else
		{
			$where.=' AND aid!=0';
		}

		$where.=$withthumb?' AND pic!=\'\'':'';
		
		$sql="SELECT * FROM `".LA_PRE."ask_question` WHERE $where ORDER BY `".LA_PRE."ask_question`.`istop` DESC,`".LA_PRE."ask_question`.`inputtime` DESC LIMIT $limit,$row";

		$data=$cacheobj->get($sql);
		if(!$data)
		{
			$data=$db->fetch_all($sql);
			foreach($data as $key =>$val)
			{
				$data[$key]['thumb']=$data[$key]['pic'];
			}
			if($data)
			{
				$cacheobj->set($sql,$data);
			}
		}
		return $data;
	}

	function get_answer_tag($para)
	{
		/*
			Ĭϲ
		*/
		$args=array('qid'=>'0',
					'limit'=>'0',
					'row'=>'16');
		foreach($para as $key => $arg)
		{
			if(isset($args[$key]))
			{
				$args[$key]=$arg;
			}
		}
		
		extract($args);
		
		$mod=!$mod?0:array_map('intval',explode(',',$mod));
		$row=intval($row)>0?intval($row):10;
		return '<?php $_DATA=get_answer_data('.$qid.','.$limit.','.$row.');foreach($_DATA as $no => $r)if(is_array($r)){?>';
	}

	function get_answer_data($qid,$limit,$row)
	{
		global $cacheobj,$db,$siteidobj,$bbsobj;
	
		$result=$_DATA=array();
		$qid=intval($qid)?intval($qid):0;
		$limit=intval($limit)?intval($limit):0;
		$row=intval($row)?intval($row):16;

		if(SITETYPE && $_SESSION['siteid'])
		{
			$where='siteid IN('.implode(',',$siteidobj->getchildid($_SESSION['siteid'])).')';
		}
		else
		{
			$where='1';
		}
		
		$where.=$qid?' AND qid='.$qid:'';
		
		$sql="SELECT * FROM `".LA_PRE."ask_answer` WHERE $where ORDER BY `".LA_PRE."ask_answer`.`id` DESC LIMIT $limit,$row";

		$data=$cacheobj->get($sql);
		if(!$data)
		{
			$data=$db->fetch_all($sql);
			if($data)
			{
				$cacheobj->set($sql,$data);
			}
		}
		return $data;
	}
?>